<?php
session_start();

// If already logged in and is staff, redirect to staff dashboard
if (isset($_SESSION['user_id']) && $_SESSION['user_type'] === 'staff') {
    header('Location: staff-dashboard.php');
    exit();
}

// If already logged in as admin or customer, redirect to appropriate page
if (isset($_SESSION['user_id'])) {
    if ($_SESSION['user_type'] === 'admin') {
        header('Location: admin-dashboard.php');
    } else {
        header('Location: customer-dashboard.php');
    }
    exit();
}
?><!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Staff Login | Cleaning Service</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <style>
        :root {
            --primary-color: #109c3d;
            --primary-dark: #0f8c3d;
            --light-bg: #f8fbff;
            --border-color: rgba(16, 156, 61, 0.2);
            --danger: #ef4444;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #f8fbff, #f1f5f4);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px;
        }

        .login-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            max-width: 500px;
            width: 100%;
            padding: 40px;
        }

        .login-header {
            text-align: center;
            margin-bottom: 40px;
        }

        .login-header h1 {
            font-size: 28px;
            font-weight: 700;
            color: #0f172a;
            margin-bottom: 10px;
        }

        .login-header p {
            color: #64748b;
            font-size: 14px;
        }

        .brand-logo {
            font-size: 48px;
            color: var(--primary-color);
            margin-bottom: 15px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            font-weight: 600;
            color: #0f172a;
            margin-bottom: 8px;
            display: block;
            font-size: 14px;
        }

        .form-control {
            width: 100%;
            padding: 12px;
            border: 1px solid var(--border-color);
            border-radius: 8px;
            font-size: 14px;
            font-family: inherit;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(16, 156, 61, 0.1);
        }

        .btn-login {
            width: 100%;
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            font-size: 15px;
            transition: all 0.3s ease;
            margin-top: 10px;
        }

        .btn-login:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(16, 156, 61, 0.3);
        }

        .btn-login:disabled {
            background: #cbd5e1;
            cursor: not-allowed;
            transform: none;
        }

        .alert {
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            animation: slideDown 0.3s ease;
        }

        .alert-danger {
            background: rgba(239, 68, 68, 0.1);
            color: var(--danger);
            border: 1px solid var(--danger);
        }

        .alert-success {
            background: rgba(16, 156, 61, 0.1);
            color: var(--primary-color);
            border: 1px solid var(--primary-color);
        }

        .login-footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid var(--border-color);
        }

        .login-footer p {
            color: #64748b;
            font-size: 14px;
            margin-bottom: 10px;
        }

        .login-footer a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .login-footer a:hover {
            text-decoration: underline;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-top: 15px;
        }

        .remember-me input[type="checkbox"] {
            cursor: pointer;
        }

        .remember-me label {
            margin: 0;
            cursor: pointer;
            font-weight: 400;
        }

        .spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top: 2px solid white;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            margin-right: 8px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @keyframes slideDown {
            from {
                transform: translateY(-20px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        @media (max-width: 600px) {
            .login-container {
                padding: 30px 20px;
                border-radius: 12px;
            }

            .login-header {
                margin-bottom: 30px;
            }

            .login-header h1 {
                font-size: 24px;
            }

            .brand-logo {
                font-size: 40px;
            }

            .form-control {
                padding: 10px;
                font-size: 16px;
            }

            .btn-login {
                padding: 10px;
            }
        }

        @media (max-width: 400px) {
            body {
                padding: 10px;
            }

            .login-container {
                padding: 20px;
                border-radius: 8px;
            }

            .login-header h1 {
                font-size: 20px;
            }

            .brand-logo {
                font-size: 36px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <div class="brand-logo">
                <i class="fa-solid fa-users-gear"></i>
            </div>
            <h1>Staff Login</h1>
            <p>Access your staff dashboard</p>
        </div>

        <div id="alertMessage"></div>

        <form id="loginForm">
            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" id="email" class="form-control" placeholder="Enter your email" required>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" class="form-control" placeholder="Enter your password" required>
            </div>

            <div class="remember-me">
                <input type="checkbox" id="rememberMe" name="rememberMe">
                <label for="rememberMe">Remember me</label>
            </div>

            <button type="submit" class="btn-login" id="submitBtn">
                <span id="btnText">Login</span>
            </button>
        </form>

        <div class="login-footer">
            <p>Are you an admin? <a href="admin-login.php">Admin Login</a></p>
            <p>Not a staff member? <a href="index.php">Back to Home</a></p>
        </div>
    </div>

    <script>
        const API_URL = 'api_handler.php';

        function showAlert(message, type = 'danger') {
            const alertDiv = document.getElementById('alertMessage');
            alertDiv.innerHTML = `<div class="alert alert-${type}">${message}</div>`;
            alertDiv.scrollIntoView({ behavior: 'smooth' });
        }

        document.getElementById('loginForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const email = document.getElementById('email').value;
            const password = document.getElementById('password').value;
            const rememberMe = document.getElementById('rememberMe').checked;

            const submitBtn = document.getElementById('submitBtn');
            const btnText = document.getElementById('btnText');
            submitBtn.disabled = true;
            btnText.innerHTML = '<span class="spinner"></span>Logging in...';

            const formData = new FormData();
            formData.append('action', 'staff_login');
            formData.append('email', email);
            formData.append('password', password);
            formData.append('remember_me', rememberMe ? '1' : '0');

            fetch(API_URL, {method: 'POST', body: formData})
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showAlert('Login successful! Redirecting...', 'success');
                        setTimeout(() => {
                            window.location.href = 'staff-dashboard.php';
                        }, 1500);
                    } else {
                        showAlert(data.message || 'Login failed. Please check your credentials.', 'danger');
                        submitBtn.disabled = false;
                        btnText.textContent = 'Login';
                    }
                })
                .catch(error => {
                    showAlert('Error connecting to server. Please try again.', 'danger');
                    submitBtn.disabled = false;
                    btnText.textContent = 'Login';
                });
        });
    </script>
</body>
</html>
